#
#VID e3cf89f0-53da-11d9-92b7-ceadd4ac2edd
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52540);
 script_cve_id("CVE-2004-1315");
 script_version ("$");
 name["english"] = "FreeBSD Ports: phpbb";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: phpbb

CVE-2004-1315
viewtopic.php in phpBB 2.x before 2.0.11 improperly URL decodes the
highlight parameter when extracting words and phrases to highlight,
which allows remote attackers to execute arbitrary PHP code by
double-encoding the highlight value so that special characters are
inserted into the result, which is then processed by PHP exec, as
exploited by the Santy.A worm.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.phpbb.com/support/documents.php?mode=changelog
http://www.phpbb.com/phpBB/viewtopic.php?f=14&t=240636
http://marc.theaimsgroup.com/?l=bugtraq&m=110029415208724
http://marc.theaimsgroup.com/?l=bugtraq&m=110079436714518
http://www.vuxml.org/freebsd/e3cf89f0-53da-11d9-92b7-ceadd4ac2edd.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: phpbb";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"phpbb");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.11")<0) {
    security_note(0, data:"Package phpbb version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
