#
#VID 2748fdde-3a3c-11de-bbc5-00e0815b8da8
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 2748fdde-3a3c-11de-bbc5-00e0815b8da8
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63969);
 script_cve_id("CVE-2009-1572");
 script_bugtraq_id(34656);
 script_version ("$");
 name["english"] = "FreeBSD Ports: quagga";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: quagga

CVE-2009-1572
The BGP daemon (bgpd) in Quagga 0.99.11 and earlier allows remote
attackers to cause a denial of service (crash) via an AS path
containing ASN elements whose string representation is longer than
expected, which triggers an assert error.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://lists.quagga.net/pipermail/quagga-dev/2009-April/006541.html
http://www.vuxml.org/freebsd/2748fdde-3a3c-11de-bbc5-00e0815b8da8.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: quagga";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"quagga");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_3")<0) {
    security_note(0, data:"Package quagga version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
