#
#VID 2de14f7a-dad9-11d8-b59a-00061bc2ad93
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52420);
 script_cve_id("CVE-2004-0600", "CVE-2004-0686");
 script_version ("$");
 name["english"] = "FreeBSD Ports: samba";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   samba
   ja-samba

CVE-2004-0600
Buffer overflow in the Samba Web Administration Tool (SWAT) in Samba
3.0.2 to 3.0.4 allows remote attackers to execute arbitrary code via
an invalid base-64 character during HTTP basic authentication.

CVE-2004-0686
Buffer overflow in Samba 2.2.x to 2.2.9, and 3.0.0 to 3.0.4, when the
'mangling method = hash' option is enabled in smb.conf, has unknown
impact and attack vectors.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.samba.org/samba/whatsnew/samba-3.0.5.html
http://www.samba.org/samba/whatsnew/samba-2.2.10.html
http://www.osvdb.org/8190
http://www.osvdb.org/8191
http://secunia.com/advisories/12130
http://www.securityfocus.com/archive/1/369698
http://www.securityfocus.com/archive/1/369706
http://www.vuxml.org/freebsd/2de14f7a-dad9-11d8-b59a-00061bc2ad93.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: samba";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"samba");
if(!isnull(bver) && revcomp(a:bver, b:"3")>=0 && revcomp(a:bver, b:"3.0.5,1")<0) {
    security_note(0, data:"Package samba version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"2.2.10")<0) {
    security_note(0, data:"Package samba version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-samba");
if(!isnull(bver) && revcomp(a:bver, b:"2.2.10.j1.0")<0) {
    security_note(0, data:"Package ja-samba version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
