#
#VID 8a835235-ae84-11dc-a5f9-001a4d49522b
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60052);
 script_cve_id("CVE-2007-6438", "CVE-2007-6439", "CVE-2007-6441", "CVE-2007-6450", "CVE-2007-6451");
 script_version ("$");
 name["english"] = "wireshark -- multiple vulnerabilities";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   wireshark
   wireshark-lite
   ethereal
   ethereal-lite
   tethereal
   tethereal-lite

CVE-2007-6438
Unspecified vulnerability in the SMB dissector in Wireshark (formerly
Ethereal) 0.99.6 allows remote attackers to cause a denial of service
via unknown vectors.  NOTE: this identifier originally included MP3
and NCP, but those issues are already covered by CVE-2007-6111.

CVE-2007-6439
Wireshark (formerly Ethereal) 0.99.6 allows remote attackers to cause
a denial of service (infinite or large loop) via the (1) IPv6 or (2)
USB dissector, which can trigger resource consumption or a crash.
NOTE: this identifier originally included Firebird/Interbase, but it
is already covered by CVE-2007-6116.  The DCP ETSI issue is already
covered by CVE-2007-6119.

CVE-2007-6441
The WiMAX dissector in Wireshark (formerly Ethereal) 0.99.6 allows
remote attackers to cause a denial of service (crash) via unknown
vectors related to 'unaligned access on some platforms.'

CVE-2007-6450
The RPL dissector in Wireshark (formerly Ethereal) 0.9.8 to 0.99.6
allows remote attackers to cause a denial of service (infinite loop)
via unknown vectors.

CVE-2007-6451
Unspecified vulnerability in the CIP dissector in Wireshark (formerly
Ethereal) 0.9.14 to 0.99.6 allows remote attackers to cause a denial
of service (crash) via unknown vectors that trigger allocation of
large amounts of memory.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.wireshark.org/security/wnpa-sec-2007-03.html
http://www.vuxml.org/freebsd/8a835235-ae84-11dc-a5f9-001a4d49522b.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "wireshark -- multiple vulnerabilities";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"wireshark");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.16")>=0 && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package wireshark version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"wireshark-lite");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.16")>=0 && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package wireshark-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ethereal");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.16")>=0 && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package ethereal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ethereal-lite");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.16")>=0 && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package ethereal-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"tethereal");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.16")>=0 && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package tethereal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"tethereal-lite");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.16")>=0 && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package tethereal-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
