#
#ADV FreeBSD-SA-04:12.jailroute.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(52654);
 script_bugtraq_id(10485);
 script_cve_id("CVE-2004-0125");
 script_version ("$");
 name["english"] = "FreeBSD Security Advisory (FreeBSD-SA-04:12.jailroute.asc)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-04:12.jailroute.asc

The jail(2) system call allows a system administrator to lock up a
process and all its descendants inside a closed environment with very
limited ability to affect the system outside that environment, even
for processes with superuser privileges.  It is an extension of, but
far more stringent than, the traditional Unix chroot(2) system call.

The FreeBSD kernel maintains internal routing tables for the purpose
of determining which interface should be used to transmit packets.
These routing tables can be manipulated by user processes running
with superuser privileges by sending messages over a routing socket.

A programming error resulting in a failure to verify that an attempt
to manipulate routing tables originated from a non-jailed process.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-04:12.jailroute.asc
Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Security Advisory (FreeBSD-SA-04:12.jailroute.asc)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"4.9", patchlevel:"10")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.8", patchlevel:"23")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
