#
#ADV FreeBSD-SA-02:20.syncache.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(52634);
 script_version ("$");
 name["english"] = "FreeBSD Security Advisory (FreeBSD-SA-02:20.syncache.asc)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-02:20.syncache.asc

The SYN cache (syncache) and SYN cookie mechanism (syncookie) are
features of the TCP/IP stack intended to improve resistance to a class
of denial of service attacks known as SYN floods.

Two related problems with syncache were triggered when syncookies were
implemented.

1) When a SYN was accepted via a syncookie, it used an uninitialized
pointer to find the TCP options for the new socket.  This pointer may
be a null pointer, which will cause the machine to crash.

2) A syncache entry is created when a SYN arrives on a listen socket.
If the application which created the listen socket was killed and
restarted --- and therefore recreated the listen socket with a
different inpcb --- an ACK (or duplicate SYN) which later arrived and
matched the existing syncache entry would cause a reference to the old
inpcb pointer.  Depending on the pointer's contents, this might result
in a system crash.

Because syncache/syncookies support was added prior to the release of
FreeBSD 4.5-RELEASE, no other releases are affected.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-02:20.syncache.asc
Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Security Advisory (FreeBSD-SA-02:20.syncache.asc)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"4.5", patchlevel:"1")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
