###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for gd CESA-2008:0146 centos4 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880140);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0146");
  script_cve_id("CVE-2006-4484", "CVE-2007-0455", "CVE-2007-2756", "CVE-2007-3472", "CVE-2007-3473", "CVE-2007-3475", "CVE-2007-3476");
  script_name(english: "CentOS Update for gd CESA-2008:0146 centos4 i386");
  desc["english"] = "

  Vulnerability Insight:
  The gd package contains a graphics library used for the dynamic creation of
  images such as PNG and JPEG.
  
  Multiple issues were discovered in the gd GIF image-handling code. A
  carefully-crafted GIF file could cause a crash or possibly execute code
  with the privileges of the application using the gd library.
  (CVE-2006-4484, CVE-2007-3475, CVE-2007-3476)
  
  An integer overflow was discovered in the gdImageCreateTrueColor()
  function, leading to incorrect memory allocations. A carefully crafted
  image could cause a crash or possibly execute code with the privileges of
  the application using the gd library. (CVE-2007-3472)
  
  A buffer over-read flaw was discovered. This could cause a crash in an
  application using the gd library to render certain strings using a
  JIS-encoded font. (CVE-2007-0455)
  
  A flaw was discovered in the gd PNG image handling code. A truncated PNG
  image could cause an infinite loop in an application using the gd library.
  (CVE-2007-2756)
  
  A flaw was discovered in the gd X BitMap (XBM) image-handling code. A
  malformed or truncated XBM image could cause a crash in an application
  using the gd library. (CVE-2007-3473)
  
  Users of gd should upgrade to these updated packages, which contain
  backported patches which resolve these issues.


  Affected Software/OS:
  gd on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-February/014732.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gd");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"gd", rpm:"gd~2.0.28~5.4E.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gd-devel", rpm:"gd-devel~2.0.28~5.4E.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gd-progs", rpm:"gd-progs~2.0.28~5.4E.el4_6.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}