###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for libxml2 CESA-2008:0886-01 centos2 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880253);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0886-01");
  script_cve_id("CVE-2003-1564", "CVE-2008-3529");
  script_name(english: "CentOS Update for libxml2 CESA-2008:0886-01 centos2 i386");
  desc["english"] = "

  Vulnerability Insight:
  The libxml2 packages provide a library that allows you to manipulate XML
  files. It includes support to read, modify, and write XML and HTML files.
  
  A heap-based buffer overflow flaw was found in the way libxml2 handled long
  XML entity names. If an application linked against libxml2 processed
  untrusted malformed XML content, it could cause the application to crash
  or, possibly, execute arbitrary code. (CVE-2008-3529)
  
  A denial of service flaw was found in the way libxml2 processed certain
  content. If an application linked against libxml2 processed malformed XML
  content, it could cause the application to use an excessive amount of CPU
  time and memory, and stop responding. (CVE-2003-1564)
  
  All users of libxml2 are advised to upgrade to these updated packages,
  which contain backported patches to resolve these issues.


  Affected Software/OS:
  libxml2 on CentOS 2

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-September/015236.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libxml2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS2")
{

  if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.4.19~11.ent", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.4.19~11.ent", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-python", rpm:"libxml2-python~2.4.19~11.ent", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}