###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for htdig RHSA-2007:1095-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870187);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2007:1095-01");
  script_cve_id("CVE-2007-6110");
  script_name(english: "RedHat Update for htdig RHSA-2007:1095-01");
  desc["english"] = "

  Vulnerability Insight:
  The ht://Dig system is a complete World Wide Web indexing and searching
  system for a small domain or intranet.
  
  A cross-site scripting flaw was discovered in a htdig search page. An
  attacker could construct a carefully crafted URL, which once visited by an 
  unsuspecting user, could cause a user's Web browser to execute malicious
  script in the context of the visited htdig search Web page. (CVE-2007-6110)
  
  Users of htdig are advised to upgrade to these updated packages, which
  contain backported patch to resolve this issue.


  Affected Software/OS:
  htdig on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2007-December/msg00001.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of htdig");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"htdig", rpm:"htdig~3.2.0b6~9.0.1.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"htdig-debuginfo", rpm:"htdig-debuginfo~3.2.0b6~9.0.1.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"htdig-web", rpm:"htdig-web~3.2.0b6~9.0.1.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"htdig", rpm:"htdig~3.2.0b6~4.el4_6", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"htdig-debuginfo", rpm:"htdig-debuginfo~3.2.0b6~4.el4_6", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"htdig-web", rpm:"htdig-web~3.2.0b6~4.el4_6", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}