###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for libexif RHSA-2007:1165-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870184);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2007:1165-01");
  script_cve_id("CVE-2007-6351", "CVE-2007-6352");
  script_name(english: "RedHat Update for libexif RHSA-2007:1165-01");
  desc["english"] = "

  Vulnerability Insight:
  The libexif packages contain the Exif library. Exif is an image file format
  specification that enables metadata tags to be added to existing JPEG, TIFF
  and RIFF files. The Exif library makes it possible to parse an Exif file
  and read this metadata.
  
  An infinite recursion flaw was found in the way libexif parses Exif image
  tags. If a victim opens a carefully crafted Exif image file, it could cause
  the application linked against libexif to crash. (CVE-2007-6351)
  
  An integer overflow flaw was found in the way libexif parses Exif image
  tags. If a victim opens a carefully crafted Exif image file, it could cause
  the application linked against libexif to execute arbitrary code, or crash.
  (CVE-2007-6352)
  
  Users of libexif are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.


  Affected Software/OS:
  libexif on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2007-December/msg00014.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libexif");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.6.13~4.0.2.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif-debuginfo", rpm:"libexif-debuginfo~0.6.13~4.0.2.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif-devel", rpm:"libexif-devel~0.6.13~4.0.2.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}