###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for speex RHSA-2008:0235-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870010);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0235-01");
  script_cve_id("CVE-2008-1686");
  script_name(english: "RedHat Update for speex RHSA-2008:0235-01");
  desc["english"] = "

  Vulnerability Insight:
  Speex is a patent-free compression format designed especially for speech.
  The Speex package contains a library for handling Speex files and sample
  encoder and decoder implementations using this library.
  
  The Speex library was found to not properly validate input values read from
  the Speex files headers. An attacker could create a malicious Speex file
  that would crash an application or, possibly, allow arbitrary code
  execution with the privileges of the application calling the Speex library.
  (CVE-2008-1686)
  
  All users of speex are advised to upgrade to these updated packages, which
  contain a backported patch to resolve this issue.


  Affected Software/OS:
  speex on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-April/msg00017.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of speex");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"speex", rpm:"speex~1.0.5~4.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"speex-debuginfo", rpm:"speex-debuginfo~1.0.5~4.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"speex-devel", rpm:"speex-devel~1.0.5~4.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"speex", rpm:"speex~1.0.4~4.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"speex-debuginfo", rpm:"speex-debuginfo~1.0.4~4.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"speex-devel", rpm:"speex-devel~1.0.4~4.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}