###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for libxslt RHSA-2008:0287-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870105);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0287-01");
  script_cve_id("CVE-2008-1767");
  script_name(english: "RedHat Update for libxslt RHSA-2008:0287-01");
  desc["english"] = "

  Vulnerability Insight:
  libxslt is a C library, based on libxml, for parsing of XML files into
  other textual formats (eg HTML, plain text and other XML representations of
  the underlying data). It uses the standard XSLT stylesheet transformation
  mechanism and, being written in plain ANSI C, is designed to be simple to
  incorporate into other applications
  
  Anthony de Almeida Lopes reported the libxslt library did not properly
  process long &quot;transformation match&quot; conditions in the XSL stylesheet files.
  An attacker could create a malicious XSL file that would cause a crash, or,
  possibly, execute and arbitrary code with the privileges of the application
  using libxslt library to perform XSL transformations. (CVE-2008-1767)
  
  All users are advised to upgrade to these updated packages, which contain a
  backported patch to resolve this issue.


  Affected Software/OS:
  libxslt on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1,
  Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3,
  Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-May/msg00016.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libxslt");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"libxslt", rpm:"libxslt~1.0.15~3", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-devel", rpm:"libxslt-devel~1.0.15~3", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-python", rpm:"libxslt-python~1.0.15~3", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"libxslt", rpm:"libxslt~1.1.17~2.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-debuginfo", rpm:"libxslt-debuginfo~1.1.17~2.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-devel", rpm:"libxslt-devel~1.1.17~2.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-python", rpm:"libxslt-python~1.1.17~2.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"libxslt", rpm:"libxslt~1.1.11~1.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-debuginfo", rpm:"libxslt-debuginfo~1.1.11~1.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-devel", rpm:"libxslt-devel~1.1.11~1.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-python", rpm:"libxslt-python~1.1.11~1.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"libxslt", rpm:"libxslt~1.0.33~6", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-debuginfo", rpm:"libxslt-debuginfo~1.0.33~6", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-devel", rpm:"libxslt-devel~1.0.33~6", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}