###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for gnutls RHSA-2008:0489-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870011);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0489-01");
  script_cve_id("CVE-2008-1948", "CVE-2008-1949", "CVE-2008-1950");
  script_name(english: "RedHat Update for gnutls RHSA-2008:0489-01");
  desc["english"] = "

  Vulnerability Insight:
  The GnuTLS Library provides support for cryptographic algorithms and
  protocols such as TLS. GnuTLS includes libtasn1, a library developed for
  ASN.1 structures management that includes DER encoding and decoding.
  
  Flaws were found in the way GnuTLS handles malicious client connections. A
  malicious remote client could send a specially crafted request to a service
  using GnuTLS that could cause the service to crash. (CVE-2008-1948,
  CVE-2008-1949, CVE-2008-1950)
  
  We believe it is possible to leverage the flaw CVE-2008-1948 to execute
  arbitrary code but have been unable to prove this at the time of releasing
  this advisory. Red Hat Enterprise Linux 5 includes applications, such as
  CUPS, that would be directly vulnerable to any such an exploit, however.
  Consequently, we have assigned it critical severity.
  
  Users of GnuTLS are advised to upgrade to these updated packages, which
  contain a backported patch that corrects these issues.


  Affected Software/OS:
  gnutls on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-May/msg00014.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gnutls");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.4.1~3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-debuginfo", rpm:"gnutls-debuginfo~1.4.1~3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.4.1~3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-utils", rpm:"gnutls-utils~1.4.1~3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}