###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for php RHSA-2008:0545-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870125);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0545-01");
  script_cve_id("CVE-2008-2051", "CVE-2007-5898", "CVE-2007-5899", "CVE-2007-4782", "CVE-2008-2107", "CVE-2008-2108");
  script_name(english: "RedHat Update for php RHSA-2008:0545-01");
  desc["english"] = "

  Vulnerability Insight:
  PHP is an HTML-embedded scripting language commonly used with the Apache
  HTTP Web server.
  
  It was discovered that the PHP escapeshellcmd() function did not properly
  escape multi-byte characters which are not valid in the locale used by the
  script. This could allow an attacker to bypass quoting restrictions imposed
  by escapeshellcmd() and execute arbitrary commands if the PHP script was
  using certain locales. Scripts using the default UTF-8 locale are not
  affected by this issue. (CVE-2008-2051)
  
  The PHP functions htmlentities() and htmlspecialchars() did not properly
  recognize partial multi-byte sequences. Certain sequences of bytes could be
  passed through these functions without being correctly HTML-escaped.
  Depending on the browser being used, an attacker could use this flaw to
  conduct cross-site scripting attacks. (CVE-2007-5898)
  
  A PHP script which used the transparent session ID configuration option, or
  which used the output_add_rewrite_var() function, could leak session
  identifiers to external web sites. If a page included an HTML form with an
  ACTION attribute referencing a non-local URL, the user's session ID would
  be included in the form data passed to that URL. (CVE-2007-5899)
  
  It was discovered that the PHP fnmatch() function did not restrict the
  length of the string argument. An attacker could use this flaw to crash the
  PHP interpreter where a script used fnmatch() on untrusted input data.
  (CVE-2007-4782)
  
  It was discovered that PHP did not properly seed its pseudo-random number
  generator used by functions such as rand() and mt_rand(), possibly allowing
  an attacker to easily predict the generated pseudo-random values.
  (CVE-2008-2107, CVE-2008-2108)
  
  As well, these updated packages fix the following bug:
  
  * after 2008-01-01, when using PEAR version 1.3.6 or older, it was not
  possible to use the PHP Extension and Application Repository (PEAR) to
  upgrade or install packages. In these updated packages, PEAR has been
  upgraded to version 1.4.9, which restores support for the current
  pear.php.net update server. The following changes were made to the PEAR
  packages included in php-pear: Console_Getopt and Archive_Tar are now
  included by default, and XML_RPC has been upgraded to version 1.5.0.
  
  All php users are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.


  Affected Software/OS:
  php on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-July/msg00017.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of php");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"php", rpm:"php~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-debuginfo", rpm:"php-debuginfo~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-domxml", rpm:"php-domxml~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-gd", rpm:"php-gd~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-imap", rpm:"php-imap~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-ldap", rpm:"php-ldap~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-mbstring", rpm:"php-mbstring~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-mysql", rpm:"php-mysql~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-ncurses", rpm:"php-ncurses~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-odbc", rpm:"php-odbc~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-pear", rpm:"php-pear~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-pgsql", rpm:"php-pgsql~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-snmp", rpm:"php-snmp~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-xmlrpc", rpm:"php-xmlrpc~4.3.9~3.22.12", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}