###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for ipsec-tools RHSA-2008:0849-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870155);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0849-01");
  script_cve_id("CVE-2008-3651", "CVE-2008-3652");
  script_name(english: "RedHat Update for ipsec-tools RHSA-2008:0849-01");
  desc["english"] = "

  Vulnerability Insight:
  The ipsec-tools package is used in conjunction with the IPsec functionality
  in the Linux kernel and includes racoon, an IKEv1 keying daemon.
  
  Two denial of service flaws were found in the ipsec-tools racoon daemon. It
  was possible for a remote attacker to cause the racoon daemon to consume
  all available memory. (CVE-2008-3651, CVE-2008-3652)
  
  Users of ipsec-tools should upgrade to this updated package, which contains
  backported patches that resolve these issues.


  Affected Software/OS:
  ipsec-tools on Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3,
  Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-August/msg00019.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ipsec-tools");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"ipsec-tools", rpm:"ipsec-tools~0.6.5~9.el5_2.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ipsec-tools-debuginfo", rpm:"ipsec-tools-debuginfo~0.6.5~9.el5_2.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"ipsec-tools", rpm:"ipsec-tools~0.3.3~7.el4_7", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ipsec-tools-debuginfo", rpm:"ipsec-tools-debuginfo~0.3.3~7.el4_7", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"ipsec-tools", rpm:"ipsec-tools~0.2.5~0.7.rhel3.5", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ipsec-tools-debuginfo", rpm:"ipsec-tools-debuginfo~0.2.5~0.7.rhel3.5", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}