###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for pidgin RHSA-2008:1023-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870104);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:1023-01");
  script_cve_id("CVE-2008-2955", "CVE-2008-2957", "CVE-2008-3532");
  script_name(english: "RedHat Update for pidgin RHSA-2008:1023-01");
  desc["english"] = "

  Vulnerability Insight:
  Pidgin is a multi-protocol Internet Messaging client.
  
  A denial-of-service flaw was found in Pidgin's MSN protocol handler. If a
  remote user was able to send, and the Pidgin user accepted, a
  carefully-crafted file request, it could result in Pidgin crashing.
  (CVE-2008-2955)
  
  A denial-of-service flaw was found in Pidgin's Universal Plug and Play
  (UPnP) request handling. A malicious UPnP server could send a request to
  Pidgin, causing it to download an excessive amount of data, consuming all
  available memory or disk space. (CVE-2008-2957)
  
  A flaw was found in the way Pidgin handled SSL certificates. The NSS SSL
  implementation in Pidgin did not properly verify the authenticity of SSL
  certificates. This could have resulted in users unknowingly connecting to a
  malicious SSL service. (CVE-2008-3532)
  
  In addition, this update upgrades pidgin from version 2.3.1 to version
  2.5.2, with many additional stability and functionality fixes from the
  Pidgin Project.
  
  Note: the Secure Internet Live Conferencing (SILC) chat network protocol
  has recently changed, affecting all versions of pidgin shipped with Red Hat
  Enterprise Linux.
  
  Pidgin cannot currently connect to the latest version of the SILC server
  (1.1.14): it fails to properly exchange keys during initial login. This
  update does not correct this. Red Hat Bugzilla #474212 (linked to in the
  References section) has more information.
  
  Note: after the errata packages are installed, Pidgin must be restarted for
  the update to take effect.
  
  All Pidgin users should upgrade to these updated packages, which contains
  Pidgin version 2.5.2 and resolves these issues.


  Affected Software/OS:
  pidgin on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-December/msg00007.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pidgin");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"finch", rpm:"finch~2.5.2~6.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"finch-devel", rpm:"finch-devel~2.5.2~6.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.5.2~6.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpurple-devel", rpm:"libpurple-devel~2.5.2~6.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpurple-perl", rpm:"libpurple-perl~2.5.2~6.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpurple-tcl", rpm:"libpurple-tcl~2.5.2~6.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pidgin", rpm:"pidgin~2.5.2~6.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pidgin-debuginfo", rpm:"pidgin-debuginfo~2.5.2~6.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pidgin-devel", rpm:"pidgin-devel~2.5.2~6.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pidgin-perl", rpm:"pidgin-perl~2.5.2~6.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}