###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bsplayer_bls_bof_vuln.nasl 1261 2009-04-07 18:45:29Z apr $
#
# BSPlayer Stack Overflow Vulnerability BLS
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800269);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1068");
  script_bugtraq_id(34190);
  script_name(english:"BSPlayer Stack Overflow Vulnerability BLS");
  desc["english"] = "

  Overview: This host is running BSPlayer Free Edition and is prone to Stack
  Overflow Vulnerability.

  Vulnerability Insight:
  This flaw is due to boundary check error while the user supplies input data
  in the context of the application.

  Impact:
  Successful exploitation will let the attacker craft a malicious arbitrary
  'bls' file and cause stack overflow in the context of the affected
  application or can also cause remote code execution.

  Impact level: Application

  Affected Software/OS:
  BSPlayer Version prior to 2.36.990 on Windows.

  Fix: Upgrade to the latest version 2.36.990
  http://www.bsplayer.org/en/bs.player/download

  References:
  http://secunia.com/advisories/34412
  http://www.milw0rm.com/exploits/8249
  http://www.milw0rm.com/exploits/8251
  http://retrogod.altervista.org/9sg_bsplayer_seh.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of BSPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("gb_bsplayer_detect.nasl");
  script_require_keys("BSPlayer/Ver");
  exit(0);
}


include("version_func.inc");

playerVer = get_kb_item("BSPlayer/Ver");
if(playerVer != NULL)
{
  # Grep for BSPlayer Free Edition version prior to 2.36.990
  if(version_is_less(version:playerVer, test_version:"2.36.990")){
    security_hole(0);
  }
}
