###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_electrasoft_32bit_ftp_detect.nasl 2213 2009-05-11 13:45:02Z may $
#
# ElectraSoft 32bit FTP Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800568);
  script_version("$Revision: 1.0 $");
  script_name(english:"ElectraSoft 32bit FTP Version Detection");
  desc["english"] = "

  Overview: This script detects the version of ElectraSoft 32bit FTP and sets
  the result in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets KB for the version of ElectraSoft 32bit FTP");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\32bit FTP";
vendName = registry_get_sz(key:key, item:"Publisher");
if("ElectraSoft" >< vendName)
{
  readmePath = registry_get_sz(key:key, item:"InstallLoaction");
  if(!readmePath){
    exit(0);
  }
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:readmePath);
  file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",string:readmePath + "\README.TXT");
  readmeText = read_file(share:share, file:file, offset:0, count:100);
  if(!readmeText){
    exit(0);
  }
  ftpVer = eregmatch(pattern:"32bit FTP ([0-9.]+)", string:readmeText);
  if(ftpVer[1]){
    set_kb_item(name:"ElectraSoft/FTP/Ver", value:ftpVer[1]);
  }
}
