###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for httpd FEDORA-2007-2214
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861534);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2214");
  script_cve_id("CVE-2007-3847", "CVE-2007-4465", "CVE-2007-1863", "CVE-2007-3304", "CVE-2006-5752", "CVE-2007-1862");
  script_name(english: "Fedora Update for httpd FEDORA-2007-2214");
  desc["english"] = "

  Vulnerability Insight:
  The Apache HTTP Server is a powerful, efficient, and extensible
  web server.


  Affected Software/OS:
  httpd on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-September/msg00320.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of httpd");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"httpd", rpm:"httpd~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-debuginfo", rpm:"httpd-debuginfo~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd", rpm:"httpd~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-manual", rpm:"httpd-manual~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-devel", rpm:"httpd-devel~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-debuginfo", rpm:"httpd-debuginfo~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-manual", rpm:"httpd-manual~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-devel", rpm:"httpd-devel~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd", rpm:"httpd~2.2.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}