###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for kdebase FEDORA-2007-2361
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861573);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2361");
  script_cve_id("CVE-2007-4569", "CVE-2007-3820", "CVE-2007-4224", "CVE-2007-4225");
  script_name(english: "Fedora Update for kdebase FEDORA-2007-2361");
  desc["english"] = "

  Vulnerability Insight:
  Core applications for the K Desktop Environment.  Included are: kdm
  (replacement for xdm), kwin (window manager), konqueror (filemanager,
  web browser, ftp client, ...), konsole (xterm replacement), kpanel
  (application starter and desktop pager), kaudio (audio server),
  kdehelp (viewer for kde help files, info and man pages), kthememgr
  (system for managing alternate theme packages) plus other KDE
  components (kcheckpass, kikbd, kscreensaver, kcontrol, kfind,
  kfontmanager, kmenuedit).


  Affected Software/OS:
  kdebase on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-October/msg00022.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kdebase");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"kdebase", rpm:"kdebase~3.5.7~13.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-extras", rpm:"kdebase-extras~3.5.7~13.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase", rpm:"kdebase~3.5.7~13.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-debuginfo", rpm:"kdebase-debuginfo~3.5.7~13.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-devel", rpm:"kdebase-devel~3.5.7~13.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-extras", rpm:"kdebase-extras~3.5.7~13.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase", rpm:"kdebase~3.5.7~13.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-devel", rpm:"kdebase-devel~3.5.7~13.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-debuginfo", rpm:"kdebase-debuginfo~3.5.7~13.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}