###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for yelp FEDORA-2007-289
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861464);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-289");
  script_cve_id("");
  script_name(english: "Fedora Update for yelp FEDORA-2007-289");
  desc["english"] = "

  Vulnerability Insight:
  Yelp is the Gnome 2 help/documentation browser. It is designed
  to help you browse all the documentation on your system in
  one central tool


  Affected Software/OS:
  yelp on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-February/msg00155.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of yelp");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"yelp", rpm:"yelp~2.14.3~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/yelp-debuginfo", rpm:"x86_64/debug/yelp-debuginfo~2.14.3~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/yelp", rpm:"x86_64/yelp~2.14.3~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/yelp-debuginfo", rpm:"i386/debug/yelp-debuginfo~2.14.3~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/yelp", rpm:"i386/yelp~2.14.3~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}