###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for tomboy FEDORA-2007-3011
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861065);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-3011");
  script_cve_id("CVE-2005-4790");
  script_name(english: "Fedora Update for tomboy FEDORA-2007-3011");
  desc["english"] = "

  Vulnerability Insight:
  Tomboy is a desktop note-taking application for Linux and Unix. Simple and easy
  to use, but with potential to help you organize the ideas and information you
  deal with every day.  The key to Tomboy's usefulness lies in the ability to
  relate notes and ideas together.  Using a WikiWiki-like linking system,
  organizing ideas is as simple as typing a name.  Branching an idea off is easy
  as pressing the Link button. And links between your ideas won't break, even when
  renaming and reorganizing them.


  Affected Software/OS:
  tomboy on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00206.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of tomboy");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"tomboy", rpm:"tomboy~0.6.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomboy", rpm:"tomboy~0.6.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomboy-debuginfo", rpm:"tomboy-debuginfo~0.6.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomboy", rpm:"tomboy~0.6.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomboy-debuginfo", rpm:"tomboy-debuginfo~0.6.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}