###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for wesnoth FEDORA-2007-3989
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861510);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-3989");
  script_cve_id("CVE-2007-5742");
  script_name(english: "Fedora Update for wesnoth FEDORA-2007-3989");
  desc["english"] = "

  Vulnerability Insight:
  The Battle for Wesnoth is a turn-based strategy game with a fantasy theme.
  
  Build up a great army, gradually turning raw recruits into hardened
  veterans. In later games, recall your toughest warriors and form a deadly
  host against whom none can stand. Choose units from a large pool of
  specialists, and hand-pick a force with the right strengths to fight well
  on different terrains against all manner of opposition.
  
  Fight to regain the throne of Wesnoth, of which you are the legitimate
  heir, or use your dread power over the Undead to dominate the land of
  mortals, or lead your glorious Orcish tribe to victory against the humans
  who dared despoil your lands. Wesnoth has many different sagas waiting to
  be played out. You can create your own custom units, and write your own
  scenarios--or even full-blown campaigns. You can also challenge your
  friends--or strangers--and fight multi-player epic fantasy battles.


  Affected Software/OS:
  wesnoth on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00006.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of wesnoth");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"wesnoth", rpm:"wesnoth~1.2.8~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wesnoth-debuginfo", rpm:"wesnoth-debuginfo~1.2.8~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wesnoth-server", rpm:"wesnoth-server~1.2.8~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wesnoth-tools", rpm:"wesnoth-tools~1.2.8~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wesnoth", rpm:"wesnoth~1.2.8~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wesnoth-server", rpm:"wesnoth-server~1.2.8~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wesnoth-debuginfo", rpm:"wesnoth-debuginfo~1.2.8~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wesnoth", rpm:"wesnoth~1.2.8~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wesnoth-tools", rpm:"wesnoth-tools~1.2.8~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}