###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for pam FEDORA-2007-546
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861494);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-546");
  script_cve_id("");
  script_name(english: "Fedora Update for pam FEDORA-2007-546");
  desc["english"] = "

  Vulnerability Insight:
  PAM (Pluggable Authentication Modules) is a system security tool that
  allows system administrators to set authentication policy without
  having to recompile programs that handle authentication.


  Affected Software/OS:
  pam on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-June/msg00159.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pam");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"pam", rpm:"pam~0.99.6.2~3.22.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/pam-debuginfo", rpm:"x86_64/debug/pam-debuginfo~0.99.6.2~3.22.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/pam", rpm:"x86_64/pam~0.99.6.2~3.22.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/pam-devel", rpm:"x86_64/pam-devel~0.99.6.2~3.22.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/pam-debuginfo", rpm:"i386/debug/pam-debuginfo~0.99.6.2~3.22.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/pam-devel", rpm:"i386/pam-devel~0.99.6.2~3.22.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/pam", rpm:"i386/pam~0.99.6.2~3.22.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}