###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for postgresql FEDORA-2007-566
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861481);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-566");
  script_cve_id("CVE-2007-2138", "CVE-2007-0555", "CVE-2007-0556");
  script_name(english: "Fedora Update for postgresql FEDORA-2007-566");
  desc["english"] = "

  Vulnerability Insight:
  PostgreSQL is an advanced Object-Relational database management system
  (DBMS) that supports almost all SQL constructs (including
  transactions, subselects and user-defined types and functions). The
  postgresql package includes the client programs and libraries that
  you'll need to access a PostgreSQL DBMS server.  These PostgreSQL
  client programs are programs that directly manipulate the internal
  structure of PostgreSQL databases on a PostgreSQL server. These client
  programs can be located on the same machine with the PostgreSQL
  server, or may be on a remote machine which accesses a PostgreSQL
  server over a network connection. This package contains the docs
  in HTML for the whole package, as well as command-line utilities for
  managing PostgreSQL databases on a PostgreSQL server.
  
  If you want to manipulate a PostgreSQL database on a remote PostgreSQL
  server, you need this package. You also need to install this package
  if you're installing the postgresql-server package.


  Affected Software/OS:
  postgresql on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-June/msg00065.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postgresql");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql-test", rpm:"x86_64/postgresql-test~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql-pl", rpm:"x86_64/postgresql-pl~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql-devel", rpm:"x86_64/postgresql-devel~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql-server", rpm:"x86_64/postgresql-server~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/postgresql-debuginfo", rpm:"x86_64/debug/postgresql-debuginfo~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql-contrib", rpm:"x86_64/postgresql-contrib~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql-libs", rpm:"x86_64/postgresql-libs~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql-tcl", rpm:"x86_64/postgresql-tcl~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql", rpm:"x86_64/postgresql~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql-python", rpm:"x86_64/postgresql-python~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql-jdbc", rpm:"x86_64/postgresql-jdbc~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/postgresql-docs", rpm:"x86_64/postgresql-docs~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql-test", rpm:"i386/postgresql-test~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql-python", rpm:"i386/postgresql-python~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql-tcl", rpm:"i386/postgresql-tcl~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql", rpm:"i386/postgresql~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql-contrib", rpm:"i386/postgresql-contrib~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql-server", rpm:"i386/postgresql-server~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql-devel", rpm:"i386/postgresql-devel~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql-libs", rpm:"i386/postgresql-libs~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql-jdbc", rpm:"i386/postgresql-jdbc~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/postgresql-debuginfo", rpm:"i386/debug/postgresql-debuginfo~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql-pl", rpm:"i386/postgresql-pl~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/postgresql-docs", rpm:"i386/postgresql-docs~8.1.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}