###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for drupal FEDORA-2008-11237
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860144);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-11237");
  script_cve_id("");
  script_name(english: "Fedora Update for drupal FEDORA-2008-11237");
  desc["english"] = "

  Vulnerability Insight:
  Equipped with a powerful blend of features, Drupal is a Content Management
  System written in PHP that can support a variety of websites ranging from
  personal weblogs to large community-driven websites.  Drupal is highly
  configurable, skinnable, and secure.


  Affected Software/OS:
  drupal on Fedora 10

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-December/msg00806.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of drupal");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC10")
{

  if(isrpmvuln(pkg:"drupal", rpm:"drupal~6.7~1.fc10", rls:"FC10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}