###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for fedora-ds-admin FEDORA-2008-3214
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860520);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-3214");
  script_cve_id("CVE-2008-0892", "CVE-2008-0893");
  script_name(english: "Fedora Update for fedora-ds-admin FEDORA-2008-3214");
  desc["english"] = "

  Vulnerability Insight:
  Fedora Administration Server is an HTTP agent that provides management features
  for Fedora Directory Server.  It provides some management web apps that can
  be used through a web browser.  It provides the authentication, access control,
  and CGI utilities used by the console.


  Affected Software/OS:
  fedora-ds-admin on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-April/msg00380.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of fedora-ds-admin");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"fedora-ds-admin", rpm:"fedora-ds-admin~1.1.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}