###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for poppler FEDORA-2008-3312
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860403);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-3312");
  script_cve_id("CVE-2008-1693", "CVE-2007-3387", "CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
  script_name(english: "Fedora Update for poppler FEDORA-2008-3312");
  desc["english"] = "

  Vulnerability Insight:
  Poppler, a PDF rendering library, it's a fork of the xpdf PDF
  viewer developed by Derek Noonburg of Glyph and Cog, LLC.


  Affected Software/OS:
  poppler on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-April/msg00522.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of poppler");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"poppler", rpm:"poppler~0.5.4~9.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}