###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for horde FEDORA-2008-5691
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860592);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-5691");
  script_cve_id("");
  script_name(english: "Fedora Update for horde FEDORA-2008-5691");
  desc["english"] = "

  Vulnerability Insight:
  The Horde Framework provides a common structure and interface for Horde
  applications (such as IMP, a web-based mail program). This RPM is
  required for all other Horde module RPMs.
  
  The Horde Project writes web applications in PHP and releases them under
  Open Source licenses. For more information (including help with Horde
  and its modules) please visit <a  rel= &qt nofollow &qt  href= &qt http://www.horde.org/ &qt >http://www.horde.org/</a>.
  
  READ /usr/share/doc/horde-3.2.1/README.Fedora AFTER INSTALLING FOR
  INSTRUCTIONS AND SECURITY!
  
  For additional functionality, also install horde-enhanced


  Affected Software/OS:
  horde on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-June/msg00959.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of horde");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"horde", rpm:"horde~3.2.1~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}