###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for yelp FEDORA-2008-6127
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860086);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-6127");
  script_cve_id("CVE-2008-2801", "CVE-2008-2802", "CVE-2008-2803", "CVE-2008-2798", "CVE-2008-2799", "CVE-2008-2811", "CVE-2008-2800", "CVE-2008-2805", "CVE-2008-2810", "CVE-2008-2807", "CVE-2008-2808", "CVE-2008-2809");
  script_name(english: "Fedora Update for yelp FEDORA-2008-6127");
  desc["english"] = "

  Vulnerability Insight:
  Yelp is the Gnome 2 help/documentation browser. It is designed
  to help you browse all the documentation on your system in
  one central tool.


  Affected Software/OS:
  yelp on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-July/msg00197.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of yelp");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"yelp", rpm:"yelp~2.20.0~10.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}