###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_xul_parsing_dos_vuln_lin.nasl 1420 2009-04-06 19:52:20Z apr $
#
# Firefox XUL Parsing Denial of Service Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800390);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1232");
  script_name(english:"Firefox XUL Parsing Denial of Service Vulnerability (Linux)");
  desc["english"] = "

  Overview: The host is installed with Mozilla Firefox browser and is prone to
  XUL Parsing Vulnerability.

  Vulnerability Insight:
  Error in browser due to improper parsing of XUL (XML) documents while opening
  a specially-crafted XML document containing long series of start-tags with no
  corresponding end-tags.

  Impact:
  Successful exploitation will let the attacker to cause the browser to crash.

  Impact Level: Application

  Affected Software/OS:
  Firefox version 3.0 to 3.0.8 on Linux.

  Fix: No solution or patch is available as on 07th April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozilla.com/en-US/firefox/firefox.html

  References:
  http://www.milw0rm.com/exploits/8306
  http://xforce.iss.net/xforce/xfdb/49521

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Grep for firefox version 3.0 to 3.0.8
if(version_in_range(version:ffVer, test_version:"3.0", test_version2:"3.0.8")){
  security_warning(0);
}
