###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Filesystem Deadlock HPSBUX00178
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835027);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00178");
  script_cve_id("");
  script_name(english: "HP-UX Update for Filesystem Deadlock HPSBUX00178");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identifiedwith HP-UX filesystem 
  deadlock software, where a local user may exploit a filesystem weakness to 
  cause a Denial of Service (DoS) 

  Impact:
  Local Denial of Service (DoS).

  Affected Software/OS:
  Filesystem Deadlock on
  HP-UX B.10.20, B.10.24, B.11.00, B.11.04 and B.11.11 on HP 9000 Series 
  700/800 filesystem deadlock software. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00967116-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Filesystem Deadlock");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"filesystem deadlock", patch_list:['PHKL_22932/PACHRDME/English'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"filesystem deadlock", patch_list:['PHKL_25033/PACHRDME/English'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.20")
{

  if(ishpuxpkgvuln(pkg:"filesystem deadlock", patch_list:['PHKL_24517/PACHRDME/English'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"filesystem deadlock", patch_list:['PHKL_24518/PACHRDME/English'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"filesystem deadlock", patch_list:['PHKL_23335'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}