###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for HP WEBM Services HPSBUX00288
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835108);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00288");
  script_cve_id("CAN-2003-0543", "CAN-2003-0544", "CAN-2003-0545");
  script_name(english: "HP-UX Update for HP WEBM Services HPSBUX00288");
  desc["english"] = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified with HP-HX running 
  HP WEBM Services. The vulnerabilities could be exploited remotely to create 
  a Denial of Service (DoS). 

  Impact:
  Remote Denial of Service (DoS)

  Affected Software/OS:
  HP WEBM Services on
  HP-UX B.11.00 running HP WEBM versions prior to A.01.05.07 HP-UX B.11.11 and 
  B.11.23 running HP WEBM versions prior to A.02.00.02 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00891831-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of HP WEBM Services");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"WBEMServices.WBEM-CORE", revision:"A.01.05.07", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"WBEMServices.WBEM-CORE", revision:"A.02.00.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"WBEMServices.WBEM-CORE", revision:"A.02.00.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
