###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for CIFS Samba Server HPSBUX01086
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835081);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "01086");
  script_cve_id("CAN-2004-0815");
  script_name(english: "HP-UX Update for CIFS Samba Server HPSBUX01086");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UXrunning the 
  CIFS Server (Samba). This vulnerability couldotentially be exploited 
  remotely to gain file access. 

  Impact:
  Remote file access

  Affected Software/OS:
  CIFS Samba Server on
  HP-UX B.11.00, B.11.11, B.11.22, and B.11.23 running HP-UX CIFS (Samba). 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00901842-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of CIFS Samba Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"CIFS-Server", revision:"A.01.11.03", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"CIFS-Server", revision:"A.01.11.03", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"CIFS-Server", revision:"A.01.11.03", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"CIFS-Server", revision:"A.01.11.03", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
