###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Apache HPSBUX02365
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835172);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02365");
  script_cve_id("CVE-2007-4465", "CVE-2008-2168", "CVE-2008-2364");
  script_name(english: "HP-UX Update for Apache HPSBUX02365");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  Apache. These vulnerabilities could be exploited remotely resulting in Cross 
  Site Scripting (XSS) or Denial of Service (DoS). 

  Impact:
  Remote Cross Site Scripting (XSS) or Denial of Service (DoS)

  Affected Software/OS:
  Apache on
  HP-UX B.11.11, B.11.23, B.11.31 running Apache v2.0.59.05 and previous 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01539432-4

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Apache");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE2", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.AUTH_LDAP", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.AUTH_LDAP2", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_JK", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_JK2", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_PERL", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_PERL2", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.PHP", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.PHP2", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.WEBPROXY", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE2", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP2", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK2", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL2", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP2", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.WEBPROXY", revision:"B.2.0.59.07.01", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE2", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.AUTH_LDAP", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.AUTH_LDAP2", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_JK", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_JK2", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_PERL", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_PERL2", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.PHP", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.PHP2", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.WEBPROXY", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE2", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP2", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK2", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL2", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP2", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.WEBPROXY", revision:"B.2.0.59.07.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE2", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP2", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK2", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL2", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP2", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.WEBPROXY", revision:"B.2.0.59.07.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}