###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for NFS HPSBUX02408
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835191);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02408");
  script_cve_id("CVE-2009-0206");
  script_name(english: "HP-UX Update for NFS HPSBUX02408");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  NFS. This vulnerability could be exploited locally resulting in a Denial of 
  Service (DoS). 

  Impact:
  Local Denial of Service (DoS)

  Affected Software/OS:
  NFS on
  HP-UX B.11.31 only running ONCplus B.11.31.05 and earlier 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01666473-2

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of NFS");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"NFS.KEY-CORE", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64ALIB", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64SLIB", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CLIENT", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CORE", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-KRN", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-PRG", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SERVER", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-CLIENT", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-CORE", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-PRG", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-SERVER", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-CLIENT", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-CORE", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-SERVER", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-CLIENT", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-CORE", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-SERVER", revision:"B.11.31.06", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}