###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for krb5 MDKSA-2007:007 (krb5)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830348);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:007");
  script_cve_id("CVE-2006-5379");
  script_name(english: "Mandriva Update for krb5 MDKSA-2007:007 (krb5)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability in the NVIDIA Xorg driver was discovered by Derek
  Abdine who found that it did not correctly verify the size of buffers
  used to render text glyphs, resulting in a crash of the server when
  displaying very long strings of text.  If a user was tricked into
  viewing a specially crafted series of glyphs, this flaw could be
  exploited to run arbitrary code with root privileges.
  
  This vulnerability exists in driver versions 1.0-8762 and 1.0-8774 and
  is corrected in 1.0-8776 which is being provided with this update.
  
  The packages can be found in the non-free/updates media.

  Affected Software/OS:
  krb5 on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00010.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of krb5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"dkms-nvidia", rpm:"dkms-nvidia~8776~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nvidia", rpm:"nvidia~8776~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nvidia-kernel", rpm:"nvidia-kernel~2.6.17~5mdv~8776~1mdk", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nvidia-kernel", rpm:"nvidia-kernel~2.6.17~5mdventerprise~8776~1mdk", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nvidia-kernel", rpm:"nvidia-kernel~2.6.17~5mdvlegacy~8776~1mdk", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}