###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdenetwork MDKSA-2007:009 (kdenetwork)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830254);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:009");
  script_cve_id("CVE-2006-6811");
  script_name(english: "Mandriva Update for kdenetwork MDKSA-2007:009 (kdenetwork)");
  desc["english"] = "

  Vulnerability Insight:

  KsIRC 1.3.12 allows remote attackers to cause a denial of service
  (crash) via a long PRIVMSG string when connecting to an Internet Relay
  Chat (IRC) server, which causes an assertion failure and results in a
  NULL pointer dereference.
  
  Updated packages are patched to address this issue.

  Affected Software/OS:
  kdenetwork on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00012.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kdenetwork");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"kdenetwork", rpm:"kdenetwork~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-common", rpm:"kdenetwork-common~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-kdict", rpm:"kdenetwork-kdict~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-kget", rpm:"kdenetwork-kget~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-knewsticker", rpm:"kdenetwork-knewsticker~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-kopete", rpm:"kdenetwork-kopete~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-kopete-latex", rpm:"kdenetwork-kopete-latex~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-kppp", rpm:"kdenetwork-kppp~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-kppp-provider", rpm:"kdenetwork-kppp-provider~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-krfb", rpm:"kdenetwork-krfb~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-ksirc", rpm:"kdenetwork-ksirc~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-ktalk", rpm:"kdenetwork-ktalk~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdenetwork-kwifimanager", rpm:"kdenetwork-kwifimanager~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdenetwork2-common", rpm:"libkdenetwork2-common~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdenetwork2-common-devel", rpm:"libkdenetwork2-common-devel~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdenetwork2-kdict", rpm:"libkdenetwork2-kdict~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdenetwork2-knewsticker", rpm:"libkdenetwork2-knewsticker~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdenetwork2-kopete", rpm:"libkdenetwork2-kopete~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdenetwork2-kopete-devel", rpm:"libkdenetwork2-kopete-devel~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdenetwork2-ksirc", rpm:"libkdenetwork2-ksirc~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdenetwork2-kwifimanager", rpm:"libkdenetwork2-kwifimanager~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lisa", rpm:"lisa~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdenetwork2-common", rpm:"lib64kdenetwork2-common~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdenetwork2-common-devel", rpm:"lib64kdenetwork2-common-devel~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdenetwork2-kdict", rpm:"lib64kdenetwork2-kdict~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdenetwork2-knewsticker", rpm:"lib64kdenetwork2-knewsticker~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdenetwork2-kopete", rpm:"lib64kdenetwork2-kopete~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdenetwork2-kopete-devel", rpm:"lib64kdenetwork2-kopete-devel~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdenetwork2-ksirc", rpm:"lib64kdenetwork2-ksirc~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdenetwork2-kwifimanager", rpm:"lib64kdenetwork2-kwifimanager~3.5.4~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}