###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for bind MDKSA-2007:149 (bind)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830001);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:149");
  script_cve_id("CVE-2007-2926", "CVE-2007-2925");
  script_name(english: "Mandriva Update for bind MDKSA-2007:149 (bind)");
  desc["english"] = "

  Vulnerability Insight:

  The DNS query id generation code in BIND9 is vulnerable to
  cryptographic analysis which provides a 1-in-8 change of guessing the
  next query ID for 50% of the query IDs, which could be used by a remote
  attacker to perform cache poisoning by an attacker (CVE-2007-2926).
  
  As well, in BIND9 9.4.x, the default ACLs were note being correctly
  set, which could allow anyone to make recursive queries and/or query
  the cache contents (CVE-2007-2925).
  
  This update provides packages which are patched to prevent these
  issues.

  Affected Software/OS:
  bind on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-07/msg00019.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of bind");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.4.1~0.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.4.1~0.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.4.1~0.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.2~8.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.2~8.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.2~8.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}