###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for pwlib MDKSA-2007:206 (pwlib)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830218);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:206");
  script_cve_id("CVE-2007-4897");
  script_name(english: "Mandriva Update for pwlib MDKSA-2007:206 (pwlib)");
  desc["english"] = "

  Vulnerability Insight:

  A memory management flaw was discovered in PWLib, that an attacker
  could use to crash an application linked with it, such as Ekiga.
  
  Updated packages have been patched to prevent these issues.

  Affected Software/OS:
  pwlib on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00003.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pwlib");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libpwlib1", rpm:"libpwlib1~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-devel", rpm:"libpwlib1-devel~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-plugins", rpm:"libpwlib1-plugins~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-plugins-avc", rpm:"libpwlib1-plugins-avc~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-plugins-dc", rpm:"libpwlib1-plugins-dc~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pwlib", rpm:"pwlib~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1", rpm:"lib64pwlib1~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-devel", rpm:"lib64pwlib1-devel~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-plugins", rpm:"lib64pwlib1-plugins~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-plugins-avc", rpm:"lib64pwlib1-plugins-avc~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-plugins-dc", rpm:"lib64pwlib1-plugins-dc~1.10.5~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libpwlib1", rpm:"libpwlib1~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-devel", rpm:"libpwlib1-devel~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-plugins", rpm:"libpwlib1-plugins~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-plugins-avc", rpm:"libpwlib1-plugins-avc~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-plugins-dc", rpm:"libpwlib1-plugins-dc~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pwlib", rpm:"pwlib~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1", rpm:"lib64pwlib1~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-devel", rpm:"lib64pwlib1-devel~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-plugins", rpm:"lib64pwlib1-plugins~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-plugins-avc", rpm:"lib64pwlib1-plugins-avc~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-plugins-dc", rpm:"lib64pwlib1-plugins-dc~1.10.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libpwlib1", rpm:"libpwlib1~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-devel", rpm:"libpwlib1-devel~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-plugins", rpm:"libpwlib1-plugins~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-plugins-avc", rpm:"libpwlib1-plugins-avc~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpwlib1-plugins-dc", rpm:"libpwlib1-plugins-dc~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pwlib", rpm:"pwlib~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1", rpm:"lib64pwlib1~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-devel", rpm:"lib64pwlib1-devel~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-plugins", rpm:"lib64pwlib1-plugins~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-plugins-avc", rpm:"lib64pwlib1-plugins-avc~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pwlib1-plugins-dc", rpm:"lib64pwlib1-plugins-dc~1.10.10~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}