###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for xfs MDKSA-2007:210 (xfs)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830081);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:210");
  script_cve_id("CVE-2007-4568", "CVE-2007-4990");
  script_name(english: "Mandriva Update for xfs MDKSA-2007:210 (xfs)");
  desc["english"] = "

  Vulnerability Insight:

  Integer overflow in the build_range function in X.Org X Font Server
  (xfs) before 1.0.5 allows context-dependent attackers to execute
  arbitrary code via (1) QueryXBitmaps and (2) QueryXExtents protocol
  requests with crafted size values, which triggers a heap-based buffer
  overflow. (CVE-2007-4568)
  
  The swap_char2b function in X.Org X Font Server (xfs) before 1.0.5
  allows context-dependent attackers to execute arbitrary code via (1)
  QueryXBitmaps and (2) QueryXExtents protocol requests with crafted
  size values that specify an arbitrary number of bytes to be swapped
  on the heap, which triggers heap corruption. (CVE-2007-4990)
  
  Updated package fixes these issues.

  Affected Software/OS:
  xfs on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00012.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xfs");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"xfs", rpm:"xfs~1.0.4~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"xfs", rpm:"xfs~1.0.2~13.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}