###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for tomcat5 MDKSA-2007:241 (tomcat5)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830069);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:241");
  script_cve_id("CVE-2007-0450", "CVE-2007-2449", "CVE-2007-2450", "CVE-2007-3382", "CVE-2007-3385", "CVE-2007-3386", "CVE-2007-5461");
  script_name(english: "Mandriva Update for tomcat5 MDKSA-2007:241 (tomcat5)");
  desc["english"] = "

  Vulnerability Insight:

  A number of vulnerabilities were found in Tomcat:
  
  A directory traversal vulnerability, when using certain proxy modules,
  allows a remote attacker to read arbitrary files via a .. (dot dot)
  sequence with various slash, backslash, or url-encoded backslash
  characters (CVE-2007-0450; affects Mandriva Linux 2007.1 only).
  
  Multiple cross-site scripting vulnerabilities in certain JSP files
  allow remote attackers to inject arbitrary web script or HTML
  (CVE-2007-2449).
  
  Multiple cross-site scripting vulnerabilities in the Manager and Host
  Manager web applications allow remote authenticated users to inject
  arbitrary web script or HTML (CVE-2007-2450).
  
  Tomcat treated single quotes as delimiters in cookies, which could
  cause sensitive information such as session IDs to be leaked and allow
  remote attackers to conduct session hijacking attacks (CVE-2007-3382).
  
  Tomcat did not properly handle the &quot; character sequence in a cookie
  value, which could cause sensitive information such as session IDs
  to be leaked and allow remote attackers to conduct session hijacking
  attacks (CVE-2007-3385).
  
  A cross-site scripting vulnerability in the Host Manager servlet
  allowed remote attackers to inject arbitrary HTML and web script via
  crafted attacks (CVE-2007-3386).
  
  Finally, an absolute path traversal vulnerability, under certain
  configurations, allows remote authenticated users to read arbitrary
  files via a WebDAV write request that specifies an entity with a
  SYSTEM tag (CVE-2007-5461).
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  tomcat5 on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-12/msg00009.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of tomcat5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"tomcat5", rpm:"tomcat5~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-admin-webapps", rpm:"tomcat5-admin-webapps~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-common-lib", rpm:"tomcat5-common-lib~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-jasper", rpm:"tomcat5-jasper~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-jasper-javadoc", rpm:"tomcat5-jasper-javadoc~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-jsp", rpm:"tomcat5-jsp~2.0~api~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-jsp", rpm:"tomcat5-jsp~2.0~api~javadoc~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-server-lib", rpm:"tomcat5-server-lib~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-servlet", rpm:"tomcat5-servlet~2.4~api~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-servlet", rpm:"tomcat5-servlet~2.4~api~javadoc~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-webapps", rpm:"tomcat5-webapps~5.5.17~6.2.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"tomcat5", rpm:"tomcat5~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-admin-webapps", rpm:"tomcat5-admin-webapps~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-common-lib", rpm:"tomcat5-common-lib~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-jasper", rpm:"tomcat5-jasper~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-jasper-javadoc", rpm:"tomcat5-jasper-javadoc~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-jsp", rpm:"tomcat5-jsp~2.0~api~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-jsp", rpm:"tomcat5-jsp~2.0~api~javadoc~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-server-lib", rpm:"tomcat5-server-lib~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-servlet", rpm:"tomcat5-servlet~2.4~api~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-servlet", rpm:"tomcat5-servlet~2.4~api~javadoc~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tomcat5-webapps", rpm:"tomcat5-webapps~5.5.23~9.2.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}