###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for ntfs-3g MDVA-2008:096 (ntfs-3g)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830723);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:096");
  script_cve_id("");
  script_name(english: "Mandriva Update for ntfs-3g MDVA-2008:096 (ntfs-3g)");
  desc["english"] = "

  Vulnerability Insight:

  In certain rare circumstances, any area of an NTFS volume, excluding
  the NTFS boot sector, could get corrupted.  The chances for this to
  happen are greater when the disk is close to full utilization and when
  using one of the more uncommon, less than 4096 byte cluster sizes.
  The updated packages correct this issue.

  Affected Software/OS:
  ntfs-3g on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-06/msg00024.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ntfs-3g");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"ntfs-3g", rpm:"ntfs-3g~1.2531~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ntfs-3g-devel", rpm:"ntfs-3g-devel~1.2531~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"ntfs-3g", rpm:"ntfs-3g~1.2531~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ntfs-3g-devel", rpm:"ntfs-3g-devel~1.2531~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}