###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for rpmdrake MDVA-2008:131 (rpmdrake)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830750);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:131");
  script_cve_id("");
  script_name(english: "Mandriva Update for rpmdrake MDVA-2008:131 (rpmdrake)");
  desc["english"] = "

  Vulnerability Insight:

  This update fixes several minor issues in rpmdrake:
  - it fixes a crash due to bad timing with the X server (#41010)
  - it fix empty per importance lists of updates in rpmdrake (list
  of all updates was OK, MandrivaUpdate was OK) (#41331) (regression
  introduced in 3.95 on 2007-09-14)
  - it makes rpmdrake only warn once per session when media XML metadata
  are newer than synthesis: in that case rpmdrake complained for every
  unsyncrhonized package (#42737)
  - it fixes a crash when selecting all packages (#40025)
  - it fixes a rare crash when canceling (#41970)

  Affected Software/OS:
  rpmdrake on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00004.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of rpmdrake");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"rpmdrake", rpm:"rpmdrake~4.9.13.5~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}