###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for alsa-plugins MDVA-2008:170 (alsa-plugins)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830560);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:170");
  script_cve_id("");
  script_name(english: "Mandriva Update for alsa-plugins MDVA-2008:170 (alsa-plugins)");
  desc["english"] = "

  Vulnerability Insight:

  The version of alsa-plugins provided with Mandriva Linux 2009.0 fails
  when trying to record sound via alsa using pulseaudio.  This updated
  package contains an upstream patch to fix this bug.

  Affected Software/OS:
  alsa-plugins on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-11/msg00010.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of alsa-plugins");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"alsa-plugins-doc", rpm:"alsa-plugins-doc~1.0.18~0.rc3.3.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"alsa-plugins-pulse-config", rpm:"alsa-plugins-pulse-config~1.0.18~0.rc3.3.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libalsa-plugins", rpm:"libalsa-plugins~1.0.18~0.rc3.3.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libalsa-plugins-jack", rpm:"libalsa-plugins-jack~1.0.18~0.rc3.3.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libalsa-plugins-pulseaudio", rpm:"libalsa-plugins-pulseaudio~1.0.18~0.rc3.3.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"alsa-plugins", rpm:"alsa-plugins~1.0.18~0.rc3.3.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64alsa-plugins", rpm:"lib64alsa-plugins~1.0.18~0.rc3.3.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64alsa-plugins-jack", rpm:"lib64alsa-plugins-jack~1.0.18~0.rc3.3.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64alsa-plugins-pulseaudio", rpm:"lib64alsa-plugins-pulseaudio~1.0.18~0.rc3.3.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}