###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for cracklib MDVA-2008:180 (cracklib)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830564);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:180");
  script_cve_id("");
  script_name(english: "Mandriva Update for cracklib MDVA-2008:180 (cracklib)");
  desc["english"] = "

  Vulnerability Insight:

  The cracklib library package was incorrectly providing the development
  package, which was preventing the compilation of anything relying on
  cracklib-devel.  This update fixes the incorrect Provides.  It also
  corrects an issue when /usr is a separate partition the fails to
  mount at start, logging in is impossible because the pam_cracklib
  module is linked to /usr/lib/libcrack.so.2.

  Affected Software/OS:
  cracklib on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-11/msg00029.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cracklib");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"cracklib", rpm:"cracklib~2.8.10~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cracklib-dicts", rpm:"cracklib-dicts~2.8.10~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcrack2", rpm:"libcrack2~2.8.10~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcrack2-devel", rpm:"libcrack2-devel~2.8.10~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcrack2-python", rpm:"libcrack2-python~2.8.10~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64crack2", rpm:"lib64crack2~2.8.10~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64crack2-devel", rpm:"lib64crack2-devel~2.8.10~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64crack2-python", rpm:"lib64crack2-python~2.8.10~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}