###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mandriva-release MDVA-2008:192 (mandriva-release)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830465);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:192");
  script_cve_id("");
  script_name(english: "Mandriva Update for mandriva-release MDVA-2008:192 (mandriva-release)");
  desc["english"] = "

  Vulnerability Insight:

  This update introduces a new mandriva-release-Mini package to be used
  for the Mandriva Mini flavor of the Mandriva Linux distribution.

  Affected Software/OS:
  mandriva-release on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-12/msg00012.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mandriva-release");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"mandriva-release-common", rpm:"mandriva-release-common~2009.0~0.11mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-release-Flash", rpm:"mandriva-release-Flash~2009.0~0.11mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-release-Free", rpm:"mandriva-release-Free~2009.0~0.11mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-release-Mini", rpm:"mandriva-release-Mini~2009.0~0.11mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-release-One", rpm:"mandriva-release-One~2009.0~0.11mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-release-Powerpack", rpm:"mandriva-release-Powerpack~2009.0~0.11mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-release", rpm:"mandriva-release~2009.0~0.11mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}