###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for x11-server-xgl MDVSA-2008:025 (x11-server-xgl)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830527);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:025");
  script_cve_id("CVE-2007-5760", "CVE-2007-5958", "CVE-2007-6427", "CVE-2007-6428", "CVE-2007-6429");
  script_name(english: "Mandriva Update for x11-server-xgl MDVSA-2008:025 (x11-server-xgl)");
  desc["english"] = "

  Vulnerability Insight:

  An input validation flaw was found in the X.org server's XFree86-Misc
  extension that could allow a malicious authorized client to cause
  a denial of service (crash), or potentially execute arbitrary code
  with root privileges on the X.org server (CVE-2007-5760).
  
  A flaw was found in the X.org server's XC-SECURITY extension that
  could allow a local user to verify the existence of an arbitrary file,
  even in directories that are not normally accessible to that user
  (CVE-2007-5958).
  
  A memory corruption flaw was found in the X.org server's XInput
  extension that could allow a malicious authorized client to cause a
  denial of service (crash) or potentially execute arbitrary code with
  root privileges on the X.org server (CVE-2007-6427).
  
  An information disclosure flaw was found in the X.org server's TOG-CUP
  extension that could allow a malicious authorized client to cause
  a denial of service (crash) or potentially view arbitrary memory
  content within the X.org server's address space (CVE-2007-6428).
  
  Two integer overflow flaws were found in the X.org server's EVI and
  MIT-SHM modules that could allow a malicious authorized client to
  cause a denial of service (crash) or potentially execute arbitrary
  code with the privileges of the X.org server (CVE-2007-6429).
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  x11-server-xgl on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00039.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of x11-server-xgl");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"x11-server-xgl", rpm:"x11-server-xgl~0.0.1~0.20070105.4.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"x11-server-xgl", rpm:"x11-server-xgl~0.0.1~0.20060714.11.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"x11-server-xgl", rpm:"x11-server-xgl~0.0.1~0.20070917.2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}