###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for krb5 MDVSA-2008:070 (krb5)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830397);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:070");
  script_cve_id("CVE-2007-5971", "CVE-2008-0062", "CVE-2008-0063", "CVE-2008-0947");
  script_name(english: "Mandriva Update for krb5 MDVSA-2008:070 (krb5)");
  desc["english"] = "

  Vulnerability Insight:

  A memory management flaw was found in the GSSAPI library used by
  Kerberos that could result in an attempt to free already freed memory,
  possibly leading to a crash or allowing the execution of arbitrary code
  (CVE-2007-5971).
  
  A flaw was discovered in how the Kerberos krb5kdc handled Kerberos v4
  protocol packets.  An unauthenticated remote attacker could use this
  flaw to crash the krb5kdc daemon, disclose portions of its memory,
  or possibly %execute arbitrary code using malformed or truncated
  Kerberos v4 protocol requests (CVE-2008-0062, CVE-2008-0063).
  
  This issue only affects krb5kdc when it has Kerberos v4 protocol
  compatibility enabled, which is a compiled-in default in all
  Kerberos versions that Mandriva Linux ships prior to Mandriva
  Linux 2008.0.  Kerberos v4 protocol support can be disabled by
  adding v4_mode=none (without quotes) to the [kdcdefaults] section
  of /etc/kerberos/krb5kdc/kdc.conf.
  
  A flaw in the RPC library as used in Kerberos' kadmind was discovered
  by Jeff Altman of Secure Endpoints.  An unauthenticated remote attacker
  could use this vulnerability to crash kadmind or possibly execute
  arbitrary code in systems with certain resource limits configured;
  this does not affect the default resource limits used by Mandriva Linux
  (CVE-2008-0947).
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  krb5 on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-03/msg00019.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of krb5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"ftp-client-krb5", rpm:"ftp-client-krb5~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ftp-server-krb5", rpm:"ftp-server-krb5~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-workstation", rpm:"krb5-workstation~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkrb53", rpm:"libkrb53~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkrb53-devel", rpm:"libkrb53-devel~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"telnet-client-krb5", rpm:"telnet-client-krb5~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"telnet-server-krb5", rpm:"telnet-server-krb5~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64krb53", rpm:"lib64krb53~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64krb53-devel", rpm:"lib64krb53-devel~1.4.3~7.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}