###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for php MDVSA-2008:126 (php)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830416);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:126");
  script_cve_id("CVE-2007-1649", "CVE-2007-4660", "CVE-2007-5898", "CVE-2007-5899", "CVE-2008-2051", "CVE-2008-2107", "CVE-2008-2108", "CVE-2008-2829");
  script_name(english: "Mandriva Update for php MDVSA-2008:126 (php)");
  desc["english"] = "

  Vulnerability Insight:

  A number of vulnerabilities have been found and corrected in PHP:
  
  PHP 5.2.1 would allow context-dependent attackers to read portions
  of heap memory by executing certain scripts with a serialized data
  input string beginning with 'S:', which did not properly track the
  number of input bytes being processed (CVE-2007-1649).
  
  A vulnerability in the chunk_split() function in PHP prior to 5.2.4
  has unknown impact and attack vectors, related to an incorrect size
  calculation (CVE-2007-4660).
  
  The htmlentities() and htmlspecialchars() functions in PHP prior to
  5.2.5 accepted partial multibyte sequences, which has unknown impact
  and attack vectors (CVE-2007-5898).
  
  The output_add_rewrite_var() function in PHP prior to 5.2.5 rewrites
  local forms in which the ACTION attribute references a non-local URL,
  which could allow a remote attacker to obtain potentially sensitive
  information by reading the requests for this URL (CVE-2007-5899).
  
  The escapeshellcmd() API function in PHP prior to 5.2.6 has unknown
  impact and context-dependent attack vectors related to incomplete
  multibyte characters (CVE-2008-2051).
  
  Weaknesses in the GENERATE_SEED macro in PHP prior to 4.4.8 and 5.2.5
  were discovered that could produce a zero seed in rare circumstances on
  32bit systems and generations a portion of zero bits during conversion
  due to insufficient precision on 64bit systems (CVE-2008-2107,
  CVE-2008-2108).
  
  The IMAP module in PHP uses obsolete API calls that allow
  context-dependent attackers to cause a denial of service (crash)
  via a long IMAP request (CVE-2008-2829).
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  php on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-07/msg00004.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of php");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libphp5_common5", rpm:"libphp5_common5~5.2.1~4.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~5.2.1~4.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.2.1~4.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.2.1~4.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-fcgi", rpm:"php-fcgi~5.2.1~4.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-imap", rpm:"php-imap~5.2.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-openssl", rpm:"php-openssl~5.2.1~4.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-zlib", rpm:"php-zlib~5.2.1~4.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php", rpm:"php~5.2.1~4.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64php5_common5", rpm:"lib64php5_common5~5.2.1~4.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}